%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_results
%
% Scope:    plot results overview figures
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell)
%           output file name (string)
%           index variables to be plotted (double)
%
% Output:   results overview figures
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_results(data,bindata,binref,gasnames,output_file_name,plotvars_bin)

tic;fprintf('Running function plot_results...\n');

if isempty(plotvars_bin)
    return
end

%% recalculate d15N_bulk
 
 bindata.all(:,3)=(bindata.all(:,4)+bindata.all(:,5))./2;
 
for i=1:width(gasnames)
    bindata.(gasnames{1,i})(:,3)=(bindata.(gasnames{1,i})(:,4)+bindata.(gasnames{1,i})(:,5))./2;
end

 binref.mean(:,3)=(binref.mean(:,4)+binref.mean(:,5))./2;
 
for i=1:width(gasnames)
    binref.(gasnames{1,i})(1,3)=(binref.(gasnames{1,i})(1,4)+binref.(gasnames{1,i})(1,5))./2;
end

%% define gas types to be plotted 

binref.mean_samples=binref.mean;
binref.std_samples=binref.std;

% for i=1:height(binref.mean)
%     if bindata.flag(i,1)==2 || bindata.flag(i,1)==3
%         binref.mean_samples(i,:)=NaN;
%         binref.std_samples(i,:)=NaN;
%     end
% end

%% plot results overview figure 1 (timeseries)

figure;
for i=1:min(width(plotvars_bin),9)
    
    if width(plotvars_bin)>6
        subplot(3,3,i); end
    if width(plotvars_bin)>4 && width(plotvars_bin)<=6
        subplot(3,2,i); end
    if width(plotvars_bin)>1 && width(plotvars_bin)<=4 
        subplot(2,2,i); end
    if width(plotvars_bin)==1
        subplot(1,1,i); end
    
    hold on;
    for k=1:width(gasnames) %3:width(gasnames)
        scatter(bindata.(gasnames{1,k})(:,1),bindata.(gasnames{1,k})(:,plotvars_bin(1,i)),10);
    end
    errorbar(binref.mean_samples(:,1),binref.mean_samples(:,plotvars_bin(1,i)),binref.std_samples(:,plotvars_bin(1,i)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','w','linewidth',1.5);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    ylabel({sprintf('%s',bindata.varlabels{1,plotvars_bin(1,i)})},'fontsize',12);
    xlabel('Time [h]','fontsize',12);  
    if i==1
    title('Time series','fontsize',12); 
    end        
    if i==min(width(plotvars_bin),9)
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames) %-2
            lll{n} = string(gasnames{1,n}); end  %string(gasnames{1,n+2}); end
        legend(lll,'location','northeast');
    end
    
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

%file_name_figure=[output_file_name '_timeseries'];
%print(gcf,file_name_figure,'-dpng', '-r800');

%% plot results overview figure 2 (mean values)

figure;

for j=1:min(width(plotvars_bin),9)
    if width(plotvars_bin)>6
        subplot(3,3,j); end
    if width(plotvars_bin)>4 && width(plotvars_bin)<=6
        subplot(3,2,j); end
    if width(plotvars_bin)>1 && width(plotvars_bin)<=4 
        subplot(2,2,j); end
    if width(plotvars_bin)==1
        subplot(1,1,j); end
    
    for i=1:width(gasnames) %3:width(gasnames)
        errorbar(i,binref.(gasnames{1,i})(1,plotvars_bin(1,j)),binref.(gasnames{1,i})(2,plotvars_bin(1,j)),'marker','o','linestyle','none','markerfacecolor','w','linewidth',1.5);
%        errorbar(i-2,binref.(gasnames{1,i})(1,plotvars_bin(1,j)),binref.(gasnames{1,i})(2,plotvars_bin(1,j)),'marker','o','linestyle','none','markerfacecolor','w','linewidth',1.5);
    hold on;
    end
    grid on;
    box on;
%    set(gca,'xtick',[1:width(gasnames)],'xticklabel',gasnames(1,3:end),'fontsize',12);
    set(gca,'xtick',1:width(gasnames),'xticklabel',gasnames(1,1:end),'fontsize',12);
    xtickangle(45);
    xlim([0 width(gasnames)+1]);
    ylabel({sprintf('%s',bindata.varlabels{1,plotvars_bin(1,j)})},'fontsize',12);
    if j==1
    title('Mean values \pm 1 \sigma','fontsize',12); end
end

x0 = 10;
y0 = 50;
ww = 900;
hh = 700;
set(gcf,'units','points','position',[x0,y0,ww,hh]);
set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

%file_name_figure=[output_file_name '_mean'];
%print(gcf,file_name_figure,'-dpng', '-r800');

%%
time_elapsed=toc; fprintf('plot_results completed (execution time: %1.2f s)\n',time_elapsed); 

end

